// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.subsystems;

import edu.wpi.first.wpilibj2.command.SubsystemBase;
import edu.wpi.first.networktables.*;

public class Limelight extends SubsystemBase {

  NetworkTable upperLimelight = NetworkTableInstance.getDefault().getTable("limelight-up");
  NetworkTable lowerLimelight = NetworkTableInstance.getDefault().getTable("limelight-down");

   // upper limelight  
   NetworkTableEntry upTx = upperLimelight.getEntry("tx");
   NetworkTableEntry upTy = upperLimelight.getEntry("ty");
   NetworkTableEntry upTa = upperLimelight.getEntry("ta");
   NetworkTableEntry upTv = upperLimelight.getEntry("tv");
  
   
   // lower limelight
   NetworkTableEntry lowTx = lowerLimelight.getEntry("tx");
   NetworkTableEntry lowTy = lowerLimelight.getEntry("ty");
   NetworkTableEntry lowTa = lowerLimelight.getEntry("ta");
   NetworkTableEntry lowTv = lowerLimelight.getEntry("tv");


  public Limelight() {

  }

  // upper limelight
  public double getuplimeX(){
    return upTx.getDouble(0);
  }

  public double getuplimeY(){
    return upTy.getDouble(0);
  }

  public double getuplimeSize(){
    return upTa.getDouble(0);
  }

  public double getuplimeTV(){
    return upTv.getDouble(0);
  }

  /**
   * Select setting for LED lights
   * @param setting - 0: use the LED Mode set in the current pipeline, 1: Off, 2:Blink, 3: On
   */
  public void setUpLED(int setting){
    upperLimelight.getEntry("ledMode").setNumber(setting);
  }

  // lower limelight
  public double getlowlimeX(){
    return lowTx.getDouble(0);
  }

  public double getlowlimeY(){
    return lowTy.getDouble(0);
  }

  public double getlowlimeSize(){
    return lowTa.getDouble(0);
  }

  public double getlowlimeTV(){
    return lowTv.getDouble(0);
  }

  /**
   * Select setting for LED lights
   * @param setting - 0: use the LED Mode set in the current pipeline, 1: Off, 2:Blink, 3: On
   */
  public void setDownLED(int setting){
    lowerLimelight.getEntry("ledMode").setNumber(setting);
  }

  @Override
  public void periodic() {
    // This method will be called once per scheduler run
  }

 
}
