// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.

// ROBOTBUILDER TYPE: Subsystem.

package frc.robot.subsystems;


import frc.robot.Constants;
import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
// BEGIN AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=IMPORTS
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;
import com.revrobotics.ColorSensorV3;

    // END AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=IMPORTS


/**
 *
 */
public class Indexer extends SubsystemBase {
    // BEGIN AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=CONSTANTS

    // END AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=CONSTANTS

    // BEGIN AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=DECLARATIONS
private WPI_TalonFX indexWheels;
private final I2C.Port i2cPort;
private final ColorSensorV3 m_colorSensor;

/**
 * 200 < is no ball
 * 240 > has a ball in position 
 */    
// END AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=DECLARATIONS
    
    /**
    *
    */
    public Indexer() {
        // BEGIN AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=CONSTRUCTORS
        indexWheels = new WPI_TalonFX(Constants.IndexerConstants.indexWheel);
        i2cPort = I2C.Port.kOnboard;
        m_colorSensor = new ColorSensorV3(i2cPort);
        indexWheels.configFactoryDefault();
        indexWheels.setNeutralMode(NeutralMode.Brake);
 


    // END AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=CONSTRUCTORS
    }

    public void index( double speed) {

        indexWheels.set(ControlMode.PercentOutput,speed);

    }

    public double getColorDistance(){
        double distance = m_colorSensor.getIR();
        SmartDashboard.putNumber("IR", distance);

        return distance;
    }

    public double getColorPorximity(){
        double proximity = m_colorSensor.getProximity();
        SmartDashboard.putNumber("Proximity", proximity);

        return proximity;
    }

    public boolean ballIsLoaded(){
        boolean ballLoaded = false;
        if(getColorPorximity() > 400){
            ballLoaded = true;
        }
        SmartDashboard.putBoolean("Ball is Loaded", ballLoaded);
        return ballLoaded;
    }


    
    @Override
    public void periodic() {
        // This method will be called once per scheduler run

    }

    @Override
    public void simulationPeriodic() {
        // This method will be called once per scheduler run when in simulation

    }

    // Put methods for controlling this subsystem
    // here. Call these from Commands.

}

