// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.

// ROBOTBUILDER TYPE: Subsystem.

package frc.robot.subsystems;

import edu.wpi.first.wpilibj.ADXRS450_Gyro;
import edu.wpi.first.wpilibj.interfaces.Gyro;
import edu.wpi.first.wpilibj.motorcontrol.Spark;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;

import frc.robot.Constants;
import frc.robot.Constants.DriveConstants;
import frc.robot.commands.ManualDriveTrainBooster;
import frc.robot.RobotContainer;

/**
 *
 */
public class DriveSubsystem extends SubsystemBase {

    private WPI_TalonFX FR;
    private WPI_TalonFX FL;
    private WPI_TalonFX RR;
    private WPI_TalonFX RL;
    private Spark blinkin;
    // Used for "had a target and lost it." below
    private double previousBallTV = -1;
    private long timeLastSawBallInYRange = -1;
    private static final long lostTargetWaitTimeMS = 3000l;
    private final Gyro m_gyro = new ADXRS450_Gyro();
    
    /**
    *
    */
    public DriveSubsystem() {
        FR = new WPI_TalonFX(Constants.DriveConstants.driveFR);
        FL = new WPI_TalonFX(Constants.DriveConstants.driveFL);
        RR = new WPI_TalonFX(Constants.DriveConstants.driveRR);
        RL = new WPI_TalonFX(Constants.DriveConstants.driveRl);
        blinkin = new Spark(3);

        /**
         * Ramping control for the drivetrain
         */
        FR.configOpenloopRamp(0.5);
        FL.configOpenloopRamp(0.5);
        RR.configOpenloopRamp(0.5);
        RL.configOpenloopRamp(0.5);
    }
    /**
     * Arcade style drive code. Usues a single joystick for robot control
     */
    
    public void ArcadeDrive(){
        double V;
        double W;
        double ABSX;
        double ABSY;
        
        double X = ABSX = RobotContainer.m_oi.limX() * 100;
        double Y = ABSY = RobotContainer.m_oi.limY() * 100 * -1;
        double T = 0.6;
        //((RobotContainer.m_oi.getThrottle() * -1) + 1) / 2;

        if (ManualDriveTrainBooster.isFullyBoosted) {
            T = 1.0;
        }

        SmartDashboard.putNumber("Drive throttle", T);
        if(ABSX < 0){
            ABSX = -ABSX;
        }
        
        if(ABSY < 0){
            ABSY = -ABSY;
        }
  
        V = (100 - ABSX) * (Y/100) + Y;
        W = (100 - ABSY) * (X/100) + X;
        
        double r = (((V-W)/2)/100)*T;
        double l = (((V+W)/2)/100)*T;
        
        FR.set(ControlMode.PercentOutput, r * -1);
        RR.set(ControlMode.PercentOutput, r * -1);
        FL.set(ControlMode.PercentOutput, l);
        RL.set(ControlMode.PercentOutput, l);
    }

    /**
     * Activates vision tracking. If a target is seen the drive has control
     * of the y-axis with the robot compensating for the x-axis
     */
    public void TowerTrack() {
        double offsetY;
        
        RobotContainer.m_Limelight.setUpLED(3);
        double tx = RobotContainer.m_Limelight.getuplimeX();
        double ty = RobotContainer.m_Limelight.getuplimeY();
        double tv = RobotContainer.m_Limelight.getuplimeTV();

        double offsetX = (tx/29.8)/1.5;
        if(RobotContainer.m_Limelight.getuplimeY() < 0){
            offsetY = ((ty/43));
        } else {
            offsetY = ((ty/6)/3);
        }
        
        //SmartDashboard.putNumber("camera x", tx);
        //SmartDashboard.putNumber("camera v", tv);
       if (tv == 1) {
            Move(offsetY + -offsetX, offsetY + offsetX);
       } else {
           ArcadeDrive();
       }
    }

    public boolean towerIsTargeted() {
        double ty = RobotContainer.m_Limelight.getuplimeY();
        return (Math.abs(ty)<=3);
    }
    
    public void towerTrackOff() {
        RobotContainer.m_Limelight.setUpLED(1);
    }

    public void ballTrack() {

        double throttleCap = 0.5;

        double tx = RobotContainer.m_Limelight.getlowlimeX();
        double ty = RobotContainer.m_Limelight.getlowlimeY();
        double tv = RobotContainer.m_Limelight.getlowlimeTV();

        double offsetX = (tx/29.8)/3;
        double offsetY = ((ty/49)/2);
       
        // had a target and lost it. 
        if ((previousBallTV > 0 && tv <= 0) && ((System.currentTimeMillis() - timeLastSawBallInYRange) <= lostTargetWaitTimeMS)) {
            // Do not progress forward or backward.
            offsetY = .2;
        }
        else {
            previousBallTV = tv;
            timeLastSawBallInYRange = System.currentTimeMillis();
        }
        /*
        SmartDashboard.putNumber("Low Camera x", tx);
        SmartDashboard.putNumber("Low Camera v", tv);
        SmartDashboard.putNumber("BallTrackDrive Left", (offsetY + offsetX));
        SmartDashboard.putNumber("BallTrackDrive Right", (offsetY + -offsetX));
        */
        // Controls all robot movement X & Y
        if (tv == 1) {

            // limit top speed to throttleCap as set above in this method 
            if (offsetY > throttleCap) {
                offsetY = throttleCap;
            }

            Move(offsetY + -offsetX, offsetY + offsetX);
        } else {
           ArcadeDrive();
        }
    }

    public void assistballTrack() {
        //double offsetY;
        double tx = RobotContainer.m_Limelight.getlowlimeX();
        //double ty = RobotContainer.m_Limelight.getlowlimeY();
        double tv = RobotContainer.m_Limelight.getlowlimeTV();

        double offsetX = (tx/29.8)/3;
        double limY = RobotContainer.m_oi.limY();
        /*
        SmartDashboard.putNumber("Low Camera x", tx);
        SmartDashboard.putNumber("Low Camera v", tv);
        SmartDashboard.putNumber("BallTrackDrive Left", (limY + offsetX));
        SmartDashboard.putNumber("BallTrackDrive Right", (limY + -offsetX));
        */

        // Robot controls only x movement. Y comes from operator.
        if (tv == 1) {
            Move(limY + -offsetX, limY + offsetX);
        } else {
           ArcadeDrive();
        }
    }

    public void ballTrackOff() {
        RobotContainer.m_Limelight.setDownLED(1);
    }

    /**
     * Drive to a certain distance
     * @param distance
     */
    public void DistanceDrive(int distance) {

        FR.set(ControlMode.Position, -distance );
        RR.set(ControlMode.Position, -distance );
        FL.set(ControlMode.Position, distance );
        RL.set(ControlMode.Position, distance );
    }

    /**
     * Drive the robot using Percent control
     * @param L - How fast to run the left side of the drivetrain
     * @param R - How fast to run the right side of the drivetrain
     */
    public void Move(double L, double R){
        FL.set(ControlMode.PercentOutput, -L);
        RL.set(ControlMode.PercentOutput, -L);
    
        FR.set(ControlMode.PercentOutput, R);
        RR.set(ControlMode.PercentOutput, R);
      }

      public void setBlinkin(double setting){
          //SmartDashboard.putNumber("blinkin setting", setting);
          blinkin.set(setting);
      }

    @Override
    public void periodic() {
        // This method will be called once per scheduler run

    }

    @Override
    public void simulationPeriodic() {
        // This method will be called once per scheduler run when in simulation

    }

    /**
   * Returns the heading of the robot.
   *
   * @return the robot's heading in degrees, from 180 to 180
   */
  public double getHeading() {
    return Math.IEEEremainder(m_gyro.getAngle(), 360) * (DriveConstants.kGyroReversed ? -1.0 : 1.0);
  }

  public void autoArcadeDrive(double forward, double rotation) {

    SmartDashboard.putNumber("AutoArcadeDrive rotation", rotation);

  }

    // Put methods for controlling this subsystem
    // here. Call these from Commands.

}

