// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.

// ROBOTBUILDER TYPE: Subsystem.

package frc.robot.subsystems;

import frc.robot.Constants;
import frc.robot.RobotContainer;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.can.TalonFX;

public class Collector extends SubsystemBase {
    
private TalonFX arm;
private TalonFX rollers;

    public Collector() {
        arm = new TalonFX(7);//Constants.IntakeConstants.intakeArm);
        rollers = new TalonFX(Constants.IntakeConstants.intakeRollers);
        /**
         * P = Increase until oscillations occur
         * I = If the postion canot quite reach the end goal increase I 
         * D = Smoothing/slowing the acceleration of the movement. Use 10x at least to 100x
         * F = Feed forward norminal power required to move
         */
        rollers.config_kP(0, 0.1);
        rollers.config_kI(0, 0.001);
        rollers.config_kD(0, 10);
        rollers.config_kF(0, 0);

        arm.config_kP(0, 0.1);
        arm.config_kI(0, 0.0);
        arm.config_kD(0, 15);
        arm.config_kF(0, 0);

        arm.config_kP(1, 0.1);
        arm.config_kI(1, 0.0);
        arm.config_kD(1, 20);
        arm.config_kF(1, 0);
    }

    public void zeroArmEncoder(){
        arm.setSelectedSensorPosition(0);
    }

    // for use in auto
    public void doArmDownRollersOn() {
        RobotContainer.m_collector.armpos(-13500);//-15332);
        RobotContainer.m_collector.armRollers(-0.4);
    }
     
    // for use in auto
    public void doArmUpRollersOff() {
        RobotContainer.m_collector.armpos(0);
        RobotContainer.m_collector.armRollers(0.0);
    }

    public void armpos( double position) {

        arm.set(ControlMode.Position,position);
        double pos = arm.getSelectedSensorPosition();
        SmartDashboard.putNumber("ArmPOS", pos);
    }

    public void armRollers( double speed) {

        rollers.set(ControlMode.PercentOutput,speed);
        SmartDashboard.putNumber("Roller Velocity", rollers.getSelectedSensorVelocity());
    }

    /** for testing */ 
    public void armMovement( double speed) {

        arm.set(ControlMode.PercentOutput,speed);
        System.out.println(RobotContainer.m_oi.limOpX());
        double pos = arm.getSelectedSensorPosition();
        System.out.println("----------------arm position = " + pos);
    }
    /** END for testing */ 

    @Override
    public void periodic() {
        // This method will be called once per scheduler run
    }

    @Override
    public void simulationPeriodic() {
        // This method will be called once per scheduler run when in simulation
    }

}