// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.

// ROBOTBUILDER TYPE: Subsystem.

package frc.robot.subsystems;


import frc.robot.Constants;
import frc.robot.RobotContainer;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonFX;
import com.ctre.phoenix.motorcontrol.can.WPI_TalonSRX;

public class Climber extends SubsystemBase {
    private WPI_TalonFX leftClimb;
    private WPI_TalonFX rightClimb;
    private WPI_TalonSRX auxLeftClimb;
    private WPI_TalonSRX auxRightClimb;

    /**
    *
    */
    public Climber() {
        // BEGIN AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=CONSTRUCTORS
        leftClimb = new WPI_TalonFX(Constants.ClimberConstants.climbL);
        rightClimb = new WPI_TalonFX(Constants.ClimberConstants.climbR);
        auxLeftClimb = new WPI_TalonSRX(Constants.ClimberConstants.auxClimbL);
        auxRightClimb = new WPI_TalonSRX(Constants.ClimberConstants.auxClimbR);

        leftClimb.configFactoryDefault();
        rightClimb.configFactoryDefault();
        auxLeftClimb.configFactoryDefault();
        auxRightClimb.configFactoryDefault();

        rightClimb.setNeutralMode(NeutralMode.Brake);
        leftClimb.setNeutralMode(NeutralMode.Brake);
        auxLeftClimb.setNeutralMode(NeutralMode.Brake);
        auxRightClimb.setNeutralMode(NeutralMode.Brake);
    }

    public void climb() {
        double speed = RobotContainer.m_oi.getOpy();
        if(speed > 0){
            rightClimb.set(ControlMode.PercentOutput,-speed);
        } else if(speed < 0){
            rightClimb.set(ControlMode.PercentOutput,-speed);
        }
        int position = 0;
        leftClimb.set(ControlMode.PercentOutput,speed);
        leftClimb.getSelectedSensorPosition(position);
    }
    //Primairy climber arms
    public void climbLeft(double speed){
        leftClimb.set(ControlMode.PercentOutput,speed);
    }

    public void climbRight(double speed){
        rightClimb.set(ControlMode.PercentOutput, speed);
    }

    //Second climber arms
    public void climbAuxLeft(double speed){
        auxLeftClimb.set(ControlMode.PercentOutput,speed);
    }

    public void climbAUXRight(double speed){
        auxRightClimb.set(ControlMode.PercentOutput, speed);
    }

    public boolean getLeftTouchSensor(){
        SmartDashboard.putBoolean("Left Touch Sensor", RobotContainer.leftTouchSensor.get());
        return RobotContainer.leftTouchSensor.get();
    }

    public boolean getRightTouchSensor(){
        SmartDashboard.putBoolean("Right Touch Sensor",RobotContainer. rightTouchSensor.get());
        return RobotContainer.rightTouchSensor.get();
    }

    public void posClimb( double position) {
        rightClimb.set(ControlMode.Follower,Constants.ClimberConstants.climbL);
        leftClimb.set(ControlMode.Position,position);
    }

    @Override
    public void periodic() {
        // This method will be called once per scheduler run

    }

    @Override
    public void simulationPeriodic() {
        // This method will be called once per scheduler run when in simulation

    }

    // Put methods for controlling this subsystem
    // here. Call these from Commands.

}

