// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;

public class ManualIntakeArm extends CommandBase {
  /** Creates a new ControlIntakeArm. */
  public ManualIntakeArm() {
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {}

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    RobotContainer.m_indexer.getColorDistance();
    if (ManualReverseMode.isReverseMode) {
      RobotContainer.m_collector.armpos(-13500);//-15000);
      RobotContainer.m_collector.armRollers(0.4);
      RobotContainer.m_storage.store(0.4);
      RobotContainer.m_indexer.getColorDistance();
      RobotContainer.m_indexer.getColorPorximity();
      if(!RobotContainer.m_indexer.ballIsLoaded()){
        //RobotContainer.m_indexer.index(-0.1);
      } else {
        RobotContainer.m_indexer.index(0.0);
      }    
    }
    else {
      RobotContainer.m_collector.armpos(-15000);//-15332);
      RobotContainer.m_collector.armRollers(-0.3);
      RobotContainer.m_storage.store(-0.4);
      RobotContainer.m_indexer.getColorDistance();
      RobotContainer.m_indexer.getColorPorximity();
      if(!RobotContainer.m_indexer.ballIsLoaded()){
        //RobotContainer.m_indexer.index(0.1);
      } else {
        RobotContainer.m_indexer.index(0.0);
      }    
    }
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_collector.armpos(0);
    RobotContainer.m_collector.armRollers(0.0);
    RobotContainer.m_storage.store(0.0);
    RobotContainer.m_indexer.index(0.0);
    }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
