// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;

public class ManualAuxClimberArms extends CommandBase {
  /** Creates a new ManualAuxClimberArms. */
  public ManualAuxClimberArms() {
    // Use addRequirements() here to declare subsystem dependencies.
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {}

  double leftJoystickY;
  double leftJoystickX;

  double leftSideBoost;
  double rightSideBoost;
  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    leftJoystickY = RobotContainer.m_oi.limOpY();
    leftJoystickX = RobotContainer.m_oi.limOpX();
    //leftJoystickY = RobotContainer.m_oi.limOpY();

    if(leftJoystickX < 0)
      {
        leftSideBoost = Math.abs(leftJoystickX)/2;
    } else if(leftJoystickX > 0){
      rightSideBoost = Math.abs(leftJoystickX)/2;
    } else {
      leftSideBoost = 0;
      rightSideBoost = 0;
    }
    RobotContainer.m_climber.climbAuxLeft(-leftJoystickY + -leftSideBoost);
    RobotContainer.m_climber.climbAUXRight(leftJoystickY + rightSideBoost);

  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_climber.climbAuxLeft(0);
    RobotContainer.m_climber.climbAUXRight(0);

  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
