// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.AutonomousCommands.AutoSubCommands;

import edu.wpi.first.wpilibj2.command.CommandBase;
import edu.wpi.first.networktables.NetworkTableInstance;
import frc.robot.Constants;
import frc.robot.RobotContainer;

public class AutoTargetAndShoot extends CommandBase {
  private boolean doTowerTrack = false;
  private boolean shotBeingPrepped = true;
  private boolean shotComplete = false;
  private int targetVelocity = Constants.ShooterConstants.highGoadShooterVelocity;

  int timer;
  public AutoTargetAndShoot(boolean doTowerTrack) {
    // Use addRequirements() here to declare subsystem dependencies.
    addRequirements(RobotContainer.m_DriveSubsystem);
    this.doTowerTrack = doTowerTrack;
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    timer = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    // Turn on Tower Track if requested
    if (this.doTowerTrack) {
      NetworkTableInstance.getDefault().getTable("limelight-up").getEntry("ledMode").setNumber(3);
      if(RobotContainer.m_Limelight.getuplimeTV() != 1){
        RobotContainer.m_DriveSubsystem.autoArcadeDrive(0, 0.3);
      } else {
        RobotContainer.m_DriveSubsystem.TowerTrack();
      }
    }

    // Engage shooter wheels at specified velocity and wait until they report having reached that velocity.
    if (shotBeingPrepped && (RobotContainer.m_shooter.getVelocity() < targetVelocity || 
                             !RobotContainer.m_DriveSubsystem.towerIsTargeted())) {
        RobotContainer.m_shooter.spinUp(targetVelocity);
        RobotContainer.m_shooter.hoodMoveDegrees(0);
    }
    // Once target velocity is reached, engage storage and index wheels to shoot
    else if (shotBeingPrepped) {
      RobotContainer.m_storage.store(-0.5);
      RobotContainer.m_indexer.index(0.5);
      shotBeingPrepped = false;
    }
    
    // Once the storage and index wheels are enaged, give them some time to complete the shot.
    if (!shotBeingPrepped && timer <= 200) {
      timer++;
    } else if (!shotBeingPrepped) {
      shotComplete = true;
    }
   }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_shooter.spinUp(0);
    RobotContainer.m_indexer.index(0);
    RobotContainer.m_storage.store(0);
    NetworkTableInstance.getDefault().getTable("limelight-up").getEntry("ledMode").setNumber(1);
    RobotContainer.m_DriveSubsystem.towerTrackOff();
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return shotComplete;
  }
}
