// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.AutonomousCommands.AutoSubCommands;

import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.RobotContainer;

public class AutoFowardOnly extends CommandBase {
  private boolean driveComplete = false;

  int timer;
  public AutoFowardOnly() {
    // Use addRequirements() here to declare subsystem dependencies.
    addRequirements(RobotContainer.m_DriveSubsystem);
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    timer = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {

    switch(timer){
      case(5):
          RobotContainer.m_DriveSubsystem.Move(0.3, 0.3);
          break;
      case(105):
          RobotContainer.m_DriveSubsystem.Move(0.0, 0.0);
          driveComplete = true;
          break;
    }

    timer++;
   }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_DriveSubsystem.Move(0.0, 0.0);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return driveComplete;
  }
}
