// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.AutonomousCommands.AutoSubCommands;

import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.ElapsedTime;
import frc.robot.RobotContainer;

public class AutoBallTrackAndIntake extends CommandBase {
  /** Creates a new AutoBallTrack. */
  private ElapsedTime elapsedTime = null;
  private int timer;
  public AutoBallTrackAndIntake() {
    addRequirements(RobotContainer.m_DriveSubsystem);
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {
    elapsedTime = new ElapsedTime();
    timer = 0;
  }

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {

    switch (timer)
    {
        case (0):
          elapsedTime.reset();
          RobotContainer.m_collector.doArmDownRollersOn();
          RobotContainer.m_storage.turnStorageOn();
          //RobotContainer.m_indexer.index(0.1);
          break;
    }
    
    RobotContainer.m_DriveSubsystem.ballTrack();

    timer++;
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    RobotContainer.m_DriveSubsystem.ballTrackOff();
    RobotContainer.m_collector.doArmUpRollersOff();
    RobotContainer.m_storage.turnStorageOff();
    //RobotContainer.m_indexer.index(0);
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return (RobotContainer.m_indexer.ballIsLoaded() || timer == 400);
  }
}
