// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands.AutonomousCommands;

import edu.wpi.first.wpilibj2.command.SequentialCommandGroup;
import frc.robot.commands.TurnToAngle;
import frc.robot.commands.AutonomousCommands.AutoSubCommands.AutoFowardOnly;
import frc.robot.commands.AutonomousCommands.AutoSubCommands.AutoBallTrackAndIntake;
import frc.robot.commands.AutonomousCommands.AutoSubCommands.AutoTargetAndShoot;
import frc.robot.commands.AutonomousCommands.AutoSubCommands.FirstAutoTargetAndShoot;


// NOTE:  Consider using this command inline, rather than writing a subclass.  For more
// information, see:
// https://docs.wpilib.org/en/stable/docs/software/commandbased/convenience-features.html
public class AutoMultiBallCommandGroup extends SequentialCommandGroup {

  public static final int AUTO_RIGHT_4_BALL = 1;
  public static final int AUTO_RIGHT_3_BALL = 2;
  public static final int AUTO_2_BALL = 3;
  public static final int AUTO_NAVX_TURN = 4;
  public static final int AUTO_TOWER_AND_SHOOT = 5;
  public static final int AUTO_SHOOT_AND_MOVE = 6;

  /** Creates a new AutoMultiBallCommandGroup. */
  public AutoMultiBallCommandGroup(int selctedAuto) {
    // Add your commands in the addCommands() call, e.g.
    // addCommands(new FooCommand(), new BarCommand());
    //addCommands(new AutoTargetAndShoot(true));
    // shoots the preloaded ball
    
    if (selctedAuto == AUTO_SHOOT_AND_MOVE) {
      addCommands(new AutoFowardOnly(),
                  new FirstAutoTargetAndShoot(true),
                  new AutoFowardOnly(),
                  new AutoFowardOnly());
    }
    else if (selctedAuto == AUTO_RIGHT_4_BALL) {
      addCommands(new FirstAutoTargetAndShoot(true), 
                  new AutoBallTrackAndIntake(), new AutoTargetAndShoot(true), 
                  new AutoBallTrackAndIntake(), new AutoTargetAndShoot(true),
                  new AutoBallTrackAndIntake(), new AutoTargetAndShoot(true));

                  this.setName("AUTO_RIGHT_4_BALL");
    }
    else if (selctedAuto == AUTO_RIGHT_3_BALL) {
      addCommands(new FirstAutoTargetAndShoot(true), 
                  new AutoBallTrackAndIntake(), new AutoTargetAndShoot(true), 
                  new AutoBallTrackAndIntake(), new AutoTargetAndShoot(true));
                  
                  this.setName("AUTO_RIGHT_3_BALL");
    }
    else if (selctedAuto == AUTO_2_BALL) {
      addCommands(new FirstAutoTargetAndShoot(true), 
                  new AutoBallTrackAndIntake(), new AutoTargetAndShoot(true));
                  
                  this.setName("AUTO_2_BALL");
    }
    else if (selctedAuto == AUTO_NAVX_TURN) {
      addCommands(new TurnToAngle(90));
      
      this.setName("AUTO_NAVX_TURN");
    }
    else if (selctedAuto == AUTO_TOWER_AND_SHOOT){
      addCommands(new FirstAutoTargetAndShoot(true));
    }
    else {
      this.setName("AUTO_NONE");
    }
  }
}