// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot.commands;

import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.wpilibj2.command.CommandBase;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import frc.robot.Constants;
import frc.robot.RobotContainer;


public class AutoHoodMovement extends CommandBase {
  
  public static boolean ENGAGED = false;
  
  public AutoHoodMovement() {
    addRequirements(RobotContainer.m_DriveSubsystem);    
  }

  // Called when the command is initially scheduled.
  @Override
  public void initialize() {}

  // Called every time the scheduler runs while the command is scheduled.
  @Override
  public void execute() {
    
    ENGAGED = true;
    
    NetworkTableInstance.getDefault().getTable("limelight-up").getEntry("ledMode").setNumber(3);
    RobotContainer.m_DriveSubsystem.TowerTrack();
    RobotContainer.m_shooter.spinUp(Constants.ShooterConstants.highGoadShooterVelocity);//8000
    RobotContainer.m_shooter.hoodMoveDegrees(20);
    
    if (RobotContainer.m_shooter.getVelocity() >= Constants.ShooterConstants.highGoadShooterVelocity && 
        RobotContainer.m_DriveSubsystem.towerIsTargeted()) {
       SmartDashboard.putString("Shooter Ready", "TRUE");
       // LEDs strobe blue
       RobotContainer.m_DriveSubsystem.setBlinkin(-0.09);

       if (DriverStation.getAlliance() == DriverStation.Alliance.Blue) {
         // strobe blue
        RobotContainer.m_DriveSubsystem.setBlinkin(-0.09);//-0.29 
       }
       else {
        if (DriverStation.getAlliance() == DriverStation.Alliance.Red) {
          // strobe red
          RobotContainer.m_DriveSubsystem.setBlinkin(-0.11);//-0.31
        }
      }
    }
    else {
      SmartDashboard.putString("Shooter Ready", "FALSE");
      
      if (DriverStation.getAlliance() == DriverStation.Alliance.Blue) {
        RobotContainer.m_DriveSubsystem.setBlinkin(-0.29);//-0.29
    } else{
        if (DriverStation.getAlliance() == DriverStation.Alliance.Red) {
            RobotContainer.m_DriveSubsystem.setBlinkin(-0.31);//-0.31
        }

      }
    }
  }

  // Called once the command ends or is interrupted.
  @Override
  public void end(boolean interrupted) {
    ENGAGED = false;
    //Shut off the LED on the limelight
    //RobotContainer.m_Limelight.setUpLED(1);
    NetworkTableInstance.getDefault().getTable("limelight-up").getEntry("ledMode").setNumber(1);
    RobotContainer.m_shooter.testSpinUp(0.0);
    RobotContainer.m_shooter.hoodMoveDegrees(0);
    SmartDashboard.putString("Shooter Ready", "FALSE");
  }

  // Returns true when the command should end.
  @Override
  public boolean isFinished() {
    return false;
  }
}
