// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.

// ROBOTBUILDER TYPE: Command.

package frc.robot.commands;
import edu.wpi.first.wpilibj2.command.CommandBase;
import frc.robot.Constants;
import frc.robot.RobotContainer;

/**
 *
 */
public class AutoFeedControl extends CommandBase {

    public AutoFeedControl() {
    }

    // Called when the command is initially scheduled.
    @Override
    public void initialize() {
    }

    // Called every time the scheduler runs while the command is scheduled.
    @Override
    public void execute() {
        if (ManualReverseMode.isReverseMode) {
            RobotContainer.m_indexer.index(-0.2); 
            RobotContainer.m_storage.store(0.4);           
        }
        else {
            double targetVelocity = 0;
            if (AutoHoodMovement.ENGAGED) {
                targetVelocity = Constants.ShooterConstants.highGoadShooterVelocity;
            }
            else if (ManualShooterControl.ENGAGED) { // low goal command
                targetVelocity = Constants.ShooterConstants.lowGoalShooterVelocity;
            }

            if (RobotContainer.m_shooter.getVelocity() >= targetVelocity) {
                RobotContainer.m_indexer.index(0.2);
                RobotContainer.m_storage.store(-0.4);
            }
        }
    }

    // Called once the command ends or is interrupted.
    @Override
    public void end(boolean interrupted) {
        RobotContainer.m_indexer.index(0.0);
        RobotContainer.m_storage.store(0.0);
    }

    // Returns true when the command should end.
    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public boolean runsWhenDisabled() {
        return false;
    }
}
