// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.

// ROBOTBUILDER TYPE: RobotContainer.

package frc.robot;

import frc.robot.commands.*;
import frc.robot.commands.AutonomousCommands.*;
import frc.robot.subsystems.*;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.smartdashboard.SendableChooser;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.button.JoystickButton;

import edu.wpi.first.wpilibj.Joystick;

/**
 * This class is where the bulk of the robot should be declared.  Since Command-based is a
 * "declarative" paradigm, very little robot logic should actually be handled in the {@link Robot}
 * periodic methods (other than the scheduler calls).  Instead, the structure of the robot
 * (including subsystems, commands, and button mappings) should be declared here.
 */
public class RobotContainer {

  private static RobotContainer m_robotContainer = new RobotContainer();

    // BEGIN AUTOGENERATED CODE, SOURCE=ROBOTBUILDER ID=DECLARATIONS
    // The robot's subsystems
    public static OI m_oi = new OI();
    public static Indexer m_indexer = new Indexer();
    public static Storage m_storage = new Storage();
    public static Collector m_collector = new Collector();
    public static Shooter m_shooter = new Shooter();
    public static Climber m_climber = new Climber();
    public static DriveSubsystem m_DriveSubsystem ;
    public static Limelight m_Limelight =new Limelight();

    // Utility systems
    public static DigitalInput leftTouchSensor = new DigitalInput(1);
    public static DigitalInput rightTouchSensor = new DigitalInput(0);
    
    // Joysticks
    private final Joystick driver = new Joystick(0);
    private final Joystick operator = new Joystick(1);
  
  // A chooser for autonomous commands
  SendableChooser<Command> m_chooser = new SendableChooser<>();

  /**
  * The container for the robot.  Contains subsystems, OI devices, and commands.
  */
  private RobotContainer() {
    
    m_DriveSubsystem = new DriveSubsystem();
    
    // Smartdashboard Subsystems
    SmartDashboard.putData(m_DriveSubsystem);

    // SmartDashboard Buttons
    SmartDashboard.putData("ArcadeDrive", new ManualArcadeDrive());
    SmartDashboard.putData("ShooterControl", new ManualShooterControl( ));
    SmartDashboard.putData("Intake", new ManualIntakeArm());
    SmartDashboard.putData("Feed", new AutoFeedControl());

    // Configure the button bindings
    configureButtonBindings();

    // Configure default commands  
    m_DriveSubsystem.setDefaultCommand(new ManualArcadeDrive() );

    // Configure autonomous sendable chooser
    m_chooser.setDefaultOption("One Ball & Move", new AutoMultiBallCommandGroup(AutoMultiBallCommandGroup.AUTO_SHOOT_AND_MOVE));
    m_chooser.addOption("One Ball & Move", new AutoMultiBallCommandGroup(AutoMultiBallCommandGroup.AUTO_SHOOT_AND_MOVE));
    m_chooser.addOption("Either Side 2 Ball", new AutoMultiBallCommandGroup(AutoMultiBallCommandGroup.AUTO_2_BALL));
    //m_chooser.addOption("Right 3 Ball", new AutoMultiBallCommandGroup(AutoMultiBallCommandGroup.AUTO_RIGHT_3_BALL));
    //m_chooser.addOption("Right 4 Ball", new AutoMultiBallCommandGroup(AutoMultiBallCommandGroup.AUTO_RIGHT_4_BALL));

    SmartDashboard.putData("Auto Mode", m_chooser);
  }

  public static RobotContainer getInstance() {
    return m_robotContainer;
  }

  /**
   * Use this method to define your button->command mappings.  Buttons can be created by
   * instantiating a {@link GenericHID} or one of its subclasses ({@link
   * edu.wpi.first.wpilibj.Joystick} or {@link XboxController}), and then passing it to a
   * {@link edu.wpi.first.wpilibj2.command.button.JoystickButton}.
   */
  private void configureButtonBindings() {
    // Manipulates arm and engages collection wheels
    new JoystickButton(driver, 1).whenHeld( new ManualIntakeArm());
    // Engages wheels pushing ball into shooting wheels
    new JoystickButton(driver, 3).whenHeld( new AutoFeedControl());
    // engages Limelight target tracking and raises / lowers shooter hood

    // High goal shooter speed with limelight tower target
    new JoystickButton(driver, 5).toggleWhenPressed(new AutoHoodMovement());
    // Low goal shooter speed adjustments
    new JoystickButton(driver, 6).toggleWhenPressed(new ManualShooterControl());

    // Engages Limelight tracking of balls.
    new JoystickButton(driver, 2).whenHeld(new AssistBallTrack());
    // Allows other Commands determine whether to reverse direction.
    new JoystickButton(driver, 11).whenHeld(new ManualReverseMode());
    // Full speed over-ride for drive train.
    new JoystickButton(driver, 8).whileHeld(new ManualDriveTrainBooster());
  }

  public Joystick getoperator() {
        return operator;
  }

    /**
    * Use this to pass the autonomous command to the main {@link Robot} class.
    *
    * @return the command to run in autonomous
    */
    public Command getAutonomousCommand() {
      // The selected command will be run in autonomous
  
      //return new AutoMultiBallCommandGroup();
      
          return m_chooser.getSelected();
    } 
}

