// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot;

import edu.wpi.first.wpilibj.Joystick;



public class OI {
    public Joystick driver = new Joystick(0);
    public Joystick operator = new Joystick(1);
    public Joystick operator2 = new Joystick(2);

    

    public OI() {
    
    }
        public double getThrottle(){
	        return driver.getThrottle();
	    }

        public double getx() {
            return driver.getX();
        }

        public double gety() {
            return driver.getY();
        }

        public double getTwist() {
            return driver.getTwist();
        }
        double DEADZONESIZE = 0.1;
    
        public double limX(){
            double x = getx();
            if(x > DEADZONESIZE){x -= DEADZONESIZE;}
            else if(x < -DEADZONESIZE) {x += DEADZONESIZE;}
            else {x = 0;}
            return x;
        }

        public double limY(){
            double y = gety() * -1;
            if(y > DEADZONESIZE){y -= DEADZONESIZE;}
            else if(y < -DEADZONESIZE) {y += DEADZONESIZE;}
            else {y = 0;}
            return y;
        }
        
        public double limR(){
            double r = RobotContainer.m_oi.getTwist();
            if(r > DEADZONESIZE){r -= DEADZONESIZE;}
            else if(r < -DEADZONESIZE) {r += DEADZONESIZE;}
            else {r = 0;}
            return r;
        }

        // operator controls
     
        public double getOpThrottle(){
	        return operator.getThrottle();
	    }

        public double getOpx() {
            return operator.getX();
        }

        public double getOpy() {
            return operator.getY();
        }

        public double getOpTwist() {
            return operator.getTwist();
        }
        

        public double limOpX(){
            double x = operator.getX();
            if(x > DEADZONESIZE){x -= DEADZONESIZE;}
            else if(x < -DEADZONESIZE) {x += DEADZONESIZE;}
            else {x = 0;}
            return x;
        }

        public double limOpY(){
            double y = operator.getY() * -1;
            if(y > DEADZONESIZE){y -= DEADZONESIZE;}
            else if(y < -DEADZONESIZE) {y += DEADZONESIZE;}
            else {y = 0;}
            return y;
        }
        
        public double limOpR(){
            double r = RobotContainer.m_oi.getOpTwist();
            if(r > DEADZONESIZE){r -= DEADZONESIZE;}
            else if(r < -DEADZONESIZE) {r += DEADZONESIZE;}
            else {r = 0;}
            return r;
        }


        public boolean opbtn11(){
            return operator.getRawButton(11);
        }

        public boolean opbtn12(){
            return operator.getRawButton(12);
        }


// operator2 controls
     
public double getOp2Throttle(){
    return operator2.getThrottle();
}

public double getOp2x() {
    return operator2.getX();
}

public double getOp2y() {
    return operator2.getY();
}

public double getOp2Twist() {
    return operator2.getTwist();
}


public double limOp2X(){
    double x = operator2.getX();
    if(x > DEADZONESIZE){x -= DEADZONESIZE;}
    else if(x < -DEADZONESIZE) {x += DEADZONESIZE;}
    else {x = 0;}
    return x;
}

public double limOp2Y(){
    double y = operator2.getY() * -1;
    if(y > DEADZONESIZE){y -= DEADZONESIZE;}
    else if(y < -DEADZONESIZE) {y += DEADZONESIZE;}
    else {y = 0;}
    return y;
}

public double limOp2R(){
    double r = RobotContainer.m_oi.getOp2Twist();
    if(r > DEADZONESIZE){r -= DEADZONESIZE;}
    else if(r < -DEADZONESIZE) {r += DEADZONESIZE;}
    else {r = 0;}
    return r;
}

    

}
