package frc.robot;

public class ElapsedTime {
    private long markerTime;

    public ElapsedTime() {
        this.markerTime = System.currentTimeMillis();
    }

    public void reset() {
        this.markerTime = System.currentTimeMillis();
    }

    /**
     * Returns true if the specified number of miliseconds has elapsed since reset
     * @param targetTimeMS
     * @return
     */
    public boolean timeHasElapsed(long targetTimeMS) {
        return ((System.currentTimeMillis() - markerTime) >= targetTimeMS);
    }
}