// RobotBuilder Version: 4.0
//
// This file was generated by RobotBuilder. It contains sections of
// code that are automatically generated and assigned by robotbuilder.
// These sections will be updated in the future when you export to
// Java from RobotBuilder. Do not put any code or make any change in
// the blocks indicating autogenerated code or it will be lost on an
// update. Deleting the comments indicating the section will prevent
// it from being updated in the future.


package frc.robot;

/**
 * The Constants class provides a convenient place for teams to hold robot-wide numerical or boolean
 * constants.  This class should not be used for any other purpose.  All constants should be
 * declared globally (i.e. public static).  Do not put anything functional in this class.
 *
 * <p>It is advised to statically import this class (or one of its inner classes) wherever the
 * constants are needed, to reduce verbosity.
 */
public class Constants {
   
     public static final class DriveConstants {
       public static final int driveFL = 1;
       public static final int driveFR = 2;
       public static final int driveRl = 3;
       public static final int driveRR = 4; 

       // The following for Navx auto drive control 
       public static final double kTurnP = 1;
       public static final double kTurnI = 0;
       public static final double kTurnD = 0;
       public static final double kTurnToleranceDeg = 5;
       public static final double kTurnRateToleranceDegPerS = 10; // degrees per second
       public static final boolean kGyroReversed = false;
     }

     public static final class ClimberConstants {
         public static final int climbL = 5;
         public static final int climbR = 6;
         public static final int auxClimbL = 14;
         public static final int auxClimbR = 15;
     }

     public static final class IntakeConstants {
         public static final int intakeArm = 7;
         public static final int intakeRollers = 8;
     }

     public static final class IndexerConstants {
       public static final int indexWheel = 9;
       public static final int colorSensorLower = 400;
       public static final int colorSensorUpper = 450;
     }

     public static final class ShooterConstants {
       public static final int shootRight = 10; //Right
       public static final int shootLeft = 11; //Left
       public static final int Clocker = 13;
       public static final int hoodL = 1;
       public static final int hoodR = 2;
       public static final int color_sensor = 3;
       // how many degrees back is your limelight rotated from perfectly vertical?
       public static final double limelightMountAngleDegrees = 0.0;
       // distance from the center of the Limelight lens to the floor
       public static final double limelightLensHeightInches = 25.18;
       // distance from the target to the floor
       public static final double goalHighHeightInches = 102.0;  // value for testing in the shop
       //public static final double goalHighHeightInches = 104.0;
       public static final double angleOfdesent = -60;
       public static final double goalHigh_ShooterDelta = Constants.ShooterConstants.goalHighHeightInches - Constants.ShooterConstants.limelightLensHeightInches;

       public static final int highGoadShooterVelocity = 6900;
       public static final int lowGoalShooterVelocity = 4800;
     }

     public static final class StorageConstants {
       public static final int storeWheel = 12;
     }

    
}

