package org.usfirst.frc.team1729.robot.subsystems;

import org.usfirst.frc.team1729.robot.Robot;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.FeedbackDevice;
import com.ctre.phoenix.motorcontrol.can.TalonSRX;

import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.Servo;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

/**
 *
 */
public class Lifter extends Subsystem {
	
	private TalonSRX Lifter1 = new TalonSRX(10);
	private TalonSRX Lifter2 = new TalonSRX(14);
	private DigitalInput MaxDown = new DigitalInput(0);
	private DigitalInput MaxUp = new DigitalInput(1);
	private Servo LiftLock = new Servo(0);



    // Put methods for controlling this subsystem
    // here. Call these from Commands.

    public void initDefaultCommand() {
        // Set the default command for a subsystem here.
        //setDefaultCommand(new MySpecialCommand());
    }
    
    public double getEncoder(){
    		Lifter1.configSelectedFeedbackSensor(FeedbackDevice.QuadEncoder, 0, 0);
    		return Lifter1.getSelectedSensorPosition(0) * -1;
    }
    public boolean MaxUP(){
    	return MaxUp.get();
    }
    
    public boolean MaxDown(){
    	return MaxDown.get();
    }
    
    public void ServoMove(double Angle)
    {
    	LiftLock.setAngle(Angle);
    }
    
    public void LifterMove(double speed)
    {
    	
    	if(getEncoder() > 55000 && speed > 0 || getEncoder() < 1000 && speed < 0)
    	{
    		Lifter1.set(ControlMode.PercentOutput, 0);
    		Lifter2.set(ControlMode.PercentOutput, 0);
    	}
    	
    	else
    	{
    		Lifter1.set(ControlMode.PercentOutput, speed); // reversed after lift motor swap 10/9/18 #######################################
    		Lifter2.set(ControlMode.PercentOutput, -speed);
    	}
    	
    	
		SmartDashboard.putBoolean("MaxDown", MaxDown.get());
		SmartDashboard.putBoolean("MaxUp", MaxUp.get());
		SmartDashboard.putNumber("Lifter Encoder", getEncoder());
		SmartDashboard.putNumber("LiftLock Servo", LiftLock.getAngle());

		//SmartDashboard.putNumber("Lift", Lifter1.getMotorOutputVoltage());
    }
    
    public void LiftOverride(double speed)
    {
    	Lifter1.set(ControlMode.PercentOutput, speed);
		Lifter2.set(ControlMode.PercentOutput, -speed);	
    }
    
}

