package org.usfirst.frc.team1729.robot.commands;

import org.usfirst.frc.team1729.robot.Robot;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

/**
 *
 */
public class SmartAutoLeft_V3 extends Command {

    public SmartAutoLeft_V3() {
        // Use requires() here to declare subsystem dependencies
        // eg. requires(chassis);
    }

    int stage;
    double startlock;
    
    Command command;
    // Called just before this Command runs the first time
    protected void initialize() {
    	stage = 1;
    	startlock = 0;
    }
    // Called repeatedly when this Command is scheduled to run
    protected void execute() {
    	if(startlock == 0){
    	command = new Wait(0.02);
    	command.start();
    	startlock = 1;
    	Robot.lifter.ServoMove(70);
    	}
    String gameData = DriverStation.getInstance().getGameSpecificMessage();
    	//SmartDashboard.putNumber("Stage", stage);
    	
    	if(command.isRunning() == false){
    	if(gameData.charAt(0) == 'R' && gameData.charAt(1) == 'R'){
    		switch(stage){
    		case 1:
    			command = new MoveDrive(0.5, 4000, 0);
    			break;
    		case 2:
    			command = new MoveTurn(90, 0.7);
    			break;
    		case 3:
    			command = new MoveDrive(0.5, 1200, 90);
    			break;
    		case 4:
    			command = new MoveLift(0.6, 20000, -0.7, 1.8);
    			break;
    			
    			case 0:	default:
    		command = new Wait(0.06);
    		break;
    		}
		}
  
    	if(gameData.charAt(0) == 'L' && gameData.charAt(1) == 'R'){
    		switch(stage){
    		case 1:
    		command = new Wait(0.02);
    			break;
    		case 2:
    		command = new MoveDrive(0.4, 2400, 0);
    		new MoveLift(0.6, 20000, -0.6, 1.6).start(); // origional 0.4 and 2 on wrist
    			break;
    		case 3:
    		command = new MoveTurn(90, 0.7);
    			break;
    		case 4:
    		command = new EncoderStop(90, 0.3);
    			break;
    		case 5:
    		command = new MoveIntake(-0.4, 2);
    			break;
    			
    			case 0:	default:
    		command = new Wait(0.06);
    		break;
    		}
    	}
    	
	  	if(gameData.charAt(1) == 'L'){
	  		switch(stage){
	  		case 1:
	  		command = new Wait(0.02);
	  			break;
	  		case 2:
	  		command = new MoveDrive(-0.6, 3000, 0);
	  		new MoveLift(1, 25000, -0.6, 1.6).start();
	  			break;
	  		case 3:
		  	command = new Wait(0.02);
	  			break;
	  		case 4:
		  	command = new MoveDrive(-0.4, 2000, 15);
		  	new MoveLift(1, 25000, 0.6, 2.4);
	  			break;
	  		case 5:
		  	command = new MoveIntake(-0.4, 3);
	  			break;
	  		case 6:
		  	command = new MoveDrive(0.2, 600, 15);
		  	new MoveGrabber("release");
	  			break;
	  		case 7:
		  	command = new MoveLift(-0.7, 1000, -1, 2);
	  			break;
	  		case 8:
		  	command = new MoveTurn(340, 0.7);
	  			break;
	  		case 9:
	  		command = new Wait(0.02);
	  			break;
	  		case 10:
		  	command = new EncoderStop(340, 0.3);
		  	new MoveIntake(0.5, 3).start();
	  			break;
	  		case 11:
		  	command = new MoveGrabber("grab");
	  			break;
	  		case 12:
		  	command = new Wait(0.02);
	  			break;
	  		case 13:
		  	command = new MoveDrive(-0.3, 500, 340);
		  	new MoveLift(1, 51000, 1, 2).start();
	  			break;
	  		case 14:
	  			command = new MoveIntake(-0.7, 2);
	  			break;
	  		case 15:
	  			command = new MoveLift(-0.6, 1500, -1, 2.2);
	  			break;
	  			
	  		case 0:	
	  		default:
    		command = new Wait(0.02);
    			break;
	  		}
	  		
	  		if(gameData.charAt(0) == 'L' && stage >= 13){
  				switch(stage){
  				case 14:
  				command = new EncoderStop(170, 0.4);
  					break;
  				case 15:
  				command = new MoveIntake(-0.4, 2);
  					break;
  					
  					
  				case 16:
  					command = new Wait(0.02);
  					default:
  					break;
  				}
  			}
	  	}
	  	command.start();
		stage += 1;
		SmartDashboard.putNumber("stage", stage);
    	}
    /*if(command.isCompleted() == true){
    	switch(stage){z
    	case 1: System.out.println("Stage 1");
    		command = new MoveTurn(90, 0.7);
    		break;
    	case 2: System.out.println("Stage 2");
    		command = new MoveTurn(270, 0.7);
    		break;
    		
    	case 0:	default:
    		command = new Wait(0.06);
    		break;
    	}
    }*/
    }
    
  
    		
    		
    		
    		
    		
    	
    	
    	
    	
    	
    	
    	
    	
    

    // Make this return true when this Command no longer needs to run execute()
    protected boolean isFinished() {
        return false;
    }

    // Called once after isFinished returns true
    protected void end() {
    }

    // Called when another command which requires one or more of the same
    // subsystems is scheduled to run
    protected void interrupted() {
    }
}
