package org.usfirst.frc.team1729.robot.commands;

import org.usfirst.frc.team1729.robot.Robot;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

/**
 *
 */
public class MoveLift extends Command {

	double LPos;
	double WTime;
	double liftspeed;
	double wristspeed;
	double timer;

   /**
    * 
    * @param LiftSpeed - Speed for Lift
    * @param LiftEncoder - Goes until encoder reaches value
    * @param WristSpeed - Speed for wrist
    * @param WristTime - Goes until it reaches encoder value
    */
    public MoveLift(double LiftSpeed, double LiftPos, double WristSpeed, double WristTime) {
        // Use requires() here to declare subsystem dependencies
        // eg. requires(chassis);
    	//requires(Robot.lifter);
    	LPos = LiftPos;
    	WTime = WristTime;
    	liftspeed = LiftSpeed;
    	wristspeed = WristSpeed;
    	timer = 0;
    }

    // Called just before this Command runs the first time
    protected void initialize() {
    	
    }

    boolean MaxUp;
    boolean MaxDown;
    // Called repeatedly when this Command is scheduled to run
    protected void execute() {
    	timer += 0.02;
    	MaxUp = Robot.lifter.MaxUP();
    	MaxDown = Robot.lifter.MaxDown();
    	
    	
    	Robot.lifter.LifterMove(liftspeed);
    	
    	if(timer > WTime){
    		Robot.wrist.WristMove(0);
    	}else{
        	Robot.wrist.WristMove(wristspeed);
    	}
    }

    // Make this return true when this Command no longer needs to run execute()
    protected boolean isFinished() 
    {
    	if(Robot.lifter.getEncoder() >= LPos && liftspeed > 0)
    	{
            return true;
    	}
    	else if(Robot.lifter.getEncoder() <= LPos && liftspeed < 0)
        {
        	return true;
        }
    	else
    	{
    		return false;
    	}
    }

    // Called once after isFinished returns true
    protected void end() {
    	Robot.lifter.LifterMove(0);
    	Robot.wrist.WristMove(0);

    }

    // Called when another command which requires one or more of the same
    // subsystems is scheduled to run
    protected void interrupted() {
    	
    }
}
