package frc.robot.subsystems.vision;

import edu.wpi.first.net.PortForwarder;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;

public class LiftCamera extends SubsystemBase {

  public LiftCamera() {
    for (int port = 5800; port <= 5809; port++) {
      PortForwarder.add(port + 20, Constants.LiftCameraConstants.LiftCameraName + ".local", port);
    }
  }

  /** Turn on the lift camera's lights */
  public Command turnOnLiftCameraLights() {
    return runOnce(() -> LimelightHelpers.setLEDMode_ForceOn(Constants.LiftCameraConstants.LiftCameraName));
  }

  /** Turn off the lift camera's lights */
  public Command turnOffLiftCameraLights() {
    return runOnce(() -> LimelightHelpers.setLEDMode_ForceOff(Constants.LiftCameraConstants.LiftCameraName));
  }
}
