package frc.robot.subsystems.vision;

import edu.wpi.first.math.VecBuilder;
import edu.wpi.first.net.PortForwarder;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.wpilibj.smartdashboard.Field2d;
import edu.wpi.first.wpilibj.smartdashboard.FieldObject2d;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj2.command.SubsystemBase;
import frc.robot.Constants;
import frc.robot.RobotContainer;

import static edu.wpi.first.units.Units.Degrees;
import static edu.wpi.first.units.Units.DegreesPerSecond;

import java.util.LinkedList;

import com.ctre.phoenix6.Utils;
import com.ctre.phoenix6.swerve.SwerveDrivetrain.SwerveDriveState;

public class BaseCameras extends SubsystemBase {

  public static Field2d field = new Field2d();

  public BaseCameras() {
    LimelightHelpers.setCameraPose_RobotSpace(
      Constants.BaseCamerasConstants.LeftLiftCameraName,
      0.328522, -0.230945, 0.212615, 0, 10, -10);
    LimelightHelpers.setCameraPose_RobotSpace(
      Constants.BaseCamerasConstants.RightLiftCameraName,
      0.328522, 0.230945, 0.212615, 0, 10, 10);
    // Forward the ports for Limelight 3s (should allow access when plugged only into the RIO via USB)
    for (int port = 5800; port <= 5809; port++) {
      PortForwarder.add(port, Constants.BaseCamerasConstants.LeftLiftCameraName + ".local", port);
      PortForwarder.add(port + 10, Constants.BaseCamerasConstants.RightLiftCameraName + ".local", port);
    }
  }

  @Override
  public void periodic() {
    // Update the simulated field pose
    SwerveDriveState curState = RobotContainer.drivetrain.getState();
    field.setRobotPose(curState.Pose);
    LimelightHelpers.SetFiducialIDFiltersOverride(Constants.BaseCamerasConstants.LeftLiftCameraName, new int[0]);
    LimelightHelpers.SetFiducialIDFiltersOverride(Constants.BaseCamerasConstants.RightLiftCameraName, new int[0]);
    LimelightHelpers.setPipelineIndex(Constants.BaseCamerasConstants.LeftLiftCameraName, 0);
    LimelightHelpers.setPipelineIndex(Constants.BaseCamerasConstants.RightLiftCameraName, 0);
    double yaw = RobotContainer.drivetrain.getPigeon2().getYaw().getValue().in(Degrees);
    LimelightHelpers.SetRobotOrientation(Constants.BaseCamerasConstants.LeftLiftCameraName, yaw, 0, 0, 0, 0, 0);
    LimelightHelpers.PoseEstimate leftPose = LimelightHelpers
      .getBotPoseEstimate_wpiBlue_MegaTag2(Constants.BaseCamerasConstants.LeftLiftCameraName);
    LimelightHelpers.SetRobotOrientation(Constants.BaseCamerasConstants.RightLiftCameraName, yaw, 0, 0, 0, 0, 0);
    LimelightHelpers.PoseEstimate rightPose = LimelightHelpers
      .getBotPoseEstimate_wpiBlue_MegaTag2(Constants.BaseCamerasConstants.RightLiftCameraName);
    // Update the field with the left and right camera pose estimates
    if (!Utils.isSimulation()) {
      if (leftPose != null) {
        FieldObject2d fieldLeftPose = field.getObject("LeftPoseEstimate");
        fieldLeftPose.setPose(leftPose.pose);
      }
      if (rightPose != null) {
        FieldObject2d fieldRightPose = field.getObject("RightPoseEstimate");
        fieldRightPose.setPose(rightPose.pose);
      }
    }
    LinkedList<LimelightHelpers.PoseEstimate> newPoses = new LinkedList<LimelightHelpers.PoseEstimate>();
    newPoses.add(leftPose);
    newPoses.add(rightPose);
    SmartDashboard.putNumber("BaseCameras/Yaw", yaw);
    for (LimelightHelpers.PoseEstimate newpose : newPoses) {
      boolean doRejectUpdate = false;
      if (newpose == null) {
        return;
      }
      if (newpose.tagCount == 0 || newpose.pose.getX() == 0 || newpose.pose.getY() == 0) {
        doRejectUpdate = true;
      }
      if (RobotContainer.drivetrain.getPigeon2().getAngularVelocityZDevice().getValue()
        .abs(DegreesPerSecond) > 360) {
        doRejectUpdate = true;
      }
      if (!doRejectUpdate) {
        double[] stdDevs = NetworkTableInstance.getDefault().getTable("limelight").getEntry("stddevs")
          .getDoubleArray(new double[12]);
        RobotContainer.drivetrain.setVisionMeasurementStdDevs(VecBuilder.fill(stdDevs[6], stdDevs[7], stdDevs[11]));
        RobotContainer.drivetrain.addVisionMeasurement(
          newpose.pose,
          Utils.fpgaToCurrentTime(newpose.timestampSeconds));
      }
    }
    SmartDashboard.putData("BaseCameras/Field", field);
  }

  /** Returns whether or not either of the lift cameras have a valid AprilTag target */
  public boolean liftCamerasHaveTarget() {
    return LimelightHelpers.getTV(Constants.BaseCamerasConstants.LeftLiftCameraName) ||
      LimelightHelpers.getTV(Constants.BaseCamerasConstants.RightLiftCameraName);
  }
}
