package frc.robot.subsystems.vision;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import edu.wpi.first.math.MatBuilder;
import edu.wpi.first.math.Nat;
import edu.wpi.first.math.geometry.Rotation3d;
import edu.wpi.first.math.geometry.Transform3d;
import edu.wpi.first.wpilibj.Filesystem;

/** Mostly borrowed from Chaos */
public class AprilTags {
  private static ArrayList<AprilTag> aprilTags;
  private static HashMap<Integer, AprilTag> aprilTagMap;

  public AprilTags() {
    Path fmap_path = Path.of(Filesystem.getDeployDirectory() + File.separator + "frc2025r2_ANDYMARK.fmap");
    String file_contents;
    try {
      file_contents = Files.readString(fmap_path);
      AprilTags.aprilTags = LoadTagLocations(file_contents);
    }
    catch (IOException e) {
      AprilTags.aprilTags = new ArrayList<AprilTag>();
    }
    aprilTagMap = new HashMap<>();
    for (AprilTag tag : AprilTags.aprilTags) {
      aprilTagMap.put(tag.id, tag);
    }
  }

  public static AprilTag GetAprilTag(int id) {
    return AprilTags.aprilTagMap.get(id);
  }

  public static ArrayList<AprilTag> LoadTagLocations(String json) {
    ArrayList<AprilTag> tags = new ArrayList<>();
    try {
      JsonNode productNode = new ObjectMapper().readTree(json);
      Transform3d coordinate_shift = new Transform3d();
      if (productNode.get("fieldlength") != null) {
        coordinate_shift = new Transform3d(
          productNode.get("fieldlength").asDouble() / 2.0,
          productNode.get("fieldwidth").asDouble() / 2.0,
          0,
          new Rotation3d());
      }
      for (var fidu : productNode.get("fiducials")) {
        double tag_size = fidu.get("size").asDouble();
        double[] transform = new ObjectMapper().readValue(fidu.get("transform").toString(), double[].class);
        var trans_mat = MatBuilder.fill(Nat.N4(), Nat.N4(), transform);
        int id = fidu.get("id").asInt();
        var tag = new AprilTag(id, trans_mat, tag_size / 1000.0, coordinate_shift);
        tags.add(tag);
      }
    }
    catch (IOException e) {
      e.printStackTrace();
    }
    return tags;
  }
}
