package frc.robot.subsystems;

import edu.wpi.first.wpilibj.Servo;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.Commands;
import edu.wpi.first.wpilibj2.command.SequentialCommandGroup;
import edu.wpi.first.wpilibj2.command.SubsystemBase;

// Set up to test the motion of the Actuonix linear servos
public class ActuonixServo extends SubsystemBase {
  private Servo exampleServo;

  public ActuonixServo() {
    exampleServo = new Servo(0);
    exampleServo.setBoundsMicroseconds(2000, 1600, 1500, 1400, 1000);
  }

  public Command extendServo() {
    return new SequentialCommandGroup(
      runOnce(() -> exampleServo.setSpeed(1)),
      Commands.waitSeconds(5),
      runOnce(() -> exampleServo.setSpeed(0))).withName("ExtendActuonixServo");
  }

  public Command retractServo() {
    return new SequentialCommandGroup(
      runOnce(() -> exampleServo.setSpeed(-1)),
      Commands.waitSeconds(5),
      runOnce(() -> exampleServo.setSpeed(0))).withName("RetractActuonixServo");
  }
}
