package frc.robot.commands;

import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.SequentialCommandGroup;
import edu.wpi.first.wpilibj2.command.WaitCommand;
import frc.robot.Constants;
import frc.robot.subsystems.Lift;
import frc.robot.subsystems.Manipulator;
import frc.robot.subsystems.vision.LiftCamera;

public class ClimbCommands {
  private Lift lift;
  private LiftCamera liftCamera;
  private Manipulator manipulator;

  public ClimbCommands(Lift lift, LiftCamera liftCamera, Manipulator manipulator) {
    this.lift = lift;
    this.liftCamera = liftCamera;
    this.manipulator = manipulator;
  }

  /** Set the lift and manipulator to be ready to attach for a climb */
  public Command prepForClimb() {
    return new SequentialCommandGroup(
      liftCamera.turnOnLiftCameraLights(),
      lift.setLiftPosition(Constants.LiftConstants.MinLiftPos),
      lift.stopLiftMotors(),
      lift.setLiftAngle(-5, -1),
      lift.setLiftPosition(1400.0, -1),
      manipulator.setManipulatorAngle(-90, -1),
      lift.setLiftAngleBrake()
    ).withName("PrepForClimb");
  }

  /** Execute a climb */
  public Command executeClimb() {
    return new SequentialCommandGroup(
      liftCamera.turnOffLiftCameraLights(),
      lift.setLiftAngleBrake(),
      lift.setLiftPosition(1400.0, -1),
      manipulator.setManipulatorAngle(30, -1),
      lift.setLiftAngle(Constants.LiftConstants.MinLiftAngle, 2.5),
      new WaitCommand(1),
      lift.stopLiftAngleMotors()
    ).withName("ExecuteClimb");
  }
}
