package frc.robot;

import com.ctre.phoenix6.StatusCode;
import com.ctre.phoenix6.configs.TalonFXConfiguration;
import com.ctre.phoenix6.configs.TalonFXConfigurator;
import com.ctre.phoenix6.hardware.TalonFX;

public class TalonUtilities {
  public static void applyTalonFXConfiguration(TalonFX talon, TalonFXConfiguration cfg) {
    TalonFXConfigurator configurator = talon.getConfigurator();
    StatusCode status = StatusCode.StatusCodeNotInitialized;
    for (int i = 0; i < 5; i++) {
      status = configurator.apply(cfg);
      if (status.isOK())
        break;
    }
    if (!status.isOK()) {
      System.out.println(
        "Could not configure TalonFX device (" + talon.getDeviceID() + "). Error: " + status.toString());
    }
  }
}