package frc.robot;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

public class DashboardLinkedNumber {
  private double value;
  private String name;
  private static List<DashboardLinkedNumber> all_updaters = new ArrayList<>();
  private Consumer<Double> onUpdate;

  public DashboardLinkedNumber(
    double startValue,
    String name,
    Consumer<Double> onUpdate) {
    this.value = startValue;
    this.name = name;
    this.onUpdate = onUpdate;
    DashboardLinkedNumber.all_updaters.add(this);
    SmartDashboard.putNumber(name, startValue);
  }

  public double get() {
    return this.value;
  }

  private void checkValue() {
    var newValue = SmartDashboard.getNumber(name, get());
    if (newValue != value) {
      value = newValue;
      onUpdate.accept(value);
    }
  }

  public static void checkAll() {
    for (DashboardLinkedNumber dashboardNumber : all_updaters) {
      dashboardNumber.checkValue();
    }
  }

}
