// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

package frc.robot;

/**
 * The Constants class provides a convenient place for teams to hold robot-wide numerical or boolean
 * constants. This class should not be used for any other purpose. All constants should be declared
 * globally (i.e. public static). Do not put anything functional in this class.
 *
 * <p> It is advised to statically import this class (or one of its inner classes) wherever the
 * constants are needed, to reduce verbosity.
 */

public final class Constants {
  public static class OperatorConstants {
    public static final int kDriverControllerPort = 0;
  }

  /** CAN Bus Names */
  public static class CB_NAMES {
    public static final String UpperArm = "UpperArm";
    public static final String Drivetrain = "Drivetrain";
    public static final String rio = "rio";
  }

  /** IDs of devices on CAN Busses. Left and right are determined from the robot's point
   * of view, looking towards the front of the bot (the side opposite the arm pivot) */
  public static class CB_IDS {
    // Drivetrain devices
    public static final int FL_DRIVE_ID = 11;
    public static final int FL_STEER_ID = 10;
    public static final int FL_CANCODER_ID = 4;
    public static final int FR_DRIVE_ID = 12;
    public static final int FR_STEER_ID = 8;
    public static final int FR_CANCODER_ID = 6;
    public static final int BR_DRIVE_ID = 14;
    public static final int BR_STEER_ID = 7;
    public static final int BR_CANCODER_ID = 3;
    public static final int BL_DRIVE_ID = 13;
    public static final int BL_STEER_ID = 9;
    public static final int BL_CANCODER_ID = 5;
    public static final int PIGEON_ID = 15;
    // Lift devices
    public static final int LIFT_ANGLE_RIGHT_ID = 18;
    public static final int LIFT_ANGLE_LEFT_ID = 17;
    public static final int LIFT_ANGLE_CANCODER_ID = 16;
    public static final int LIFT_HEIGHT_RIGHT_ID = 19;
    public static final int LIFT_HEIGHT_LEFT_ID = 20;
    // Manipulator devices
    public static final int MANIPULATOR_WHEELS_ID = 21;
    public static final int MANIPULATOR_WHEELS_V2_ID = 3;
    public static final int MANIPULATOR_ANGLE_ID = 22;
    public static final int MANIPULATOR_ANGLE_CANCODER_ID = 23;
    // Intake devices
    public static final int INTAKE_ANGLE_ID = 0; // TODO:ME - set this
    public static final int INTAKE_ACTUATOR_ID = 0; // TODO:ME - set this
  }

  /** The IDs of digital input devices */
  public static class DIGITAL_INPUT_IDS {
    public static final int MANIPULATOR_LINEBREAK_ID = 0;
  }

  /** Constants used by the BaseCameras subsystem */
  public static class BaseCamerasConstants {
    // Limelight names
    public static final String LeftLiftCameraName = "limelight-liftl";
    public static final String RightLiftCameraName = "limelight-liftr";
  }

  /** Constants used by the LiftCamera subsystem */
  public static class LiftCameraConstants {
    // Limelight name
    public static final String LiftCameraName = "limelight-lift";
  }

  /** Constants used by the Intake subsystem */
  public static class IntakeConstants {
    // Max speed of the intake
    public static final double MaxIntakeSpeed = 0.05;
    // Max angle of the actuator
    public static final double MaxActuatorAngle = 0.4;
    // Min angle of the actuator
    public static final double MinActuatorAngle = -0.4;
  }

  /** Constants used by the LED subsystem */
  public static class LEDConstants {
    // The PWM port the LED strip is controlled by
    public static final int LED_PORT = 2;
    // The width of the LED strip in pixels
    public static final int LED_WIDTH = 144;
  }

  /** Constants used by the Lift subsystem */
  public static class LiftConstants {
    /** The default proximity, in degrees, to the target position/angle which will
     * exit the setPosition/setAngle command and start the next one in a sequence
     */
    public static final double LiftPosDefaultProximity = 100;
    public static final double LiftAngleDefaultProximity = 2.5;
    /** Max rate of change for the lift angle, in degrees */
    public static final double MaxLiftAngleRate = 0.1;
    /** Max position for the lift angle, in degrees */
    public static final double MaxLiftAngle = 15;
    /** Min position for the lift angle, in degrees */
    public static final double MinLiftAngle = -95;
    /** Max rate of change for the lift height */
    public static final double MaxLiftRate = 0.3;
    /** Max position for the lift, in degrees */
    public static final double MaxLiftPos = 6700;
    /** Min position for the lift, in degrees */
    public static final double MinLiftPos = 0;
    public static final double StoreHeight = 0.0;
  }

  public static class ManipulatorConstants {
    /** The acceptable error in angle position, in degrees */
    public static final double ManipulatorAngleDefaultProximity = 5;
    public static final double StoreAngle = 0.0;
    // Max speed of the wheels
    public static final double MaxWheelsSpeed = 1;
    // Max speed of the manipulator angle change
    public static final double MaxManipulatorAngleSpeed = 0.15;
    // Max angle of the manipulator in degrees
    public static final double MaxManipulatorAngle = 80;
    // Min angle of the manipulator in degrees
    public static final double MinManipulatorAngle = -100;
  }

  /** Enum to denote which face of the hexagonal reef we are targeting*/
  // IDs are arranged as follows:
  //       3
  //    2     4
  //    1     5
  //       0
  public static enum ReefFace {
    CLOSE(0), CLOSELEFT(1), CLOSERIGHT(5), FARLEFT(2), FARRIGHT(4), FAR(3);

    /** ReefFace value. */
    public final int value;

    @Override
    public String toString() {
      return this.name();
    }

    ReefFace(int value) {
      this.value = value;
    }
  }

  /** Enum to denote which side of a hexagonal reef face we are targeting.
   * Left and right are from the robot's point of view, looking at the reef */
  public static enum ReefSide {
    LEFT, RIGHT;

    @Override
    public String toString() {
      return this.name();
    }
  }

  /** Enum to denote the height of the coral branch we are targeting */
  public static enum ReefHeight {
    L1, L2, L3, L4;

    @Override
    public String toString() {
      return this.name();
    }
  }
}
